#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// ?????????? ???? ??????
#define MAX_N 200005


long long diffs[MAX_N];
long long sums[MAX_N];


int compare_long_long(const void *a, const void *b) {
    long long val_a = *(const long long*)a;
    long long val_b = *(const long long*)b;
    if (val_a < val_b) return -1;
    if (val_a > val_b) return 1;
    return 0;
}


long long count_pairs_in_sorted_array(long long arr[], int n) {
    long long total_greetings = 0;
    long long current_count = 0;

    for (int i = 0; i < n; ++i) {

        if (i == 0 || arr[i] == arr[i-1]) {
            current_count++;
        } else {

            total_greetings += (current_count * (current_count - 1)) / 2;

            current_count = 1;
        }
    }


    total_greetings += (current_count * (current_count - 1)) / 2;

    return total_greetings;
}

int main() {
    int N;


    if (scanf("%d", &N) != 1) {
        return 1;
    }

    for (int i = 0; i < N; ++i) {
        long long x, y;
        scanf("%lld %lld", &x, &y);


        diffs[i] = x - y;
        sums[i] = x + y;
    }


    qsort(diffs, N, sizeof(long long), compare_long_long);
    qsort(sums, N, sizeof(long long), compare_long_long);

    long long total_greetings = 0;
    total_greetings += count_pairs_in_sorted_array(diffs, N);
    total_greetings += count_pairs_in_sorted_array(sums, N);

    printf("%lld\n", total_greetings);

    return 0;
}